<?php

namespace App\Filament\Resources\InvoiceResource\Pages;

use Filament\Actions;
use Filament\Actions\Action;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Resources\InvoiceResource;
use Filament\Support\Actions\Concerns\CanOpenUrl;

class EditInvoice extends EditRecord
{
    protected static string $resource = InvoiceResource::class;

    protected function getHeaderActions(): array
    {
        return [
            // buka tab baru
            Action::make('cetakInvoice')
                ->label('Cetak Invoice')
                ->icon('heroicon-o-printer')
                ->color('success')
                ->url(fn() => route('invoice.cetak', $this->record), shouldOpenInNewTab: true),

            Actions\DeleteAction::make(),
        ];
    }
}
