<?php

namespace App\Filament\Resources\ProductResource\RelationManagers;

use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\RelationManagers\RelationManager;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ResepProdukRelationManager extends RelationManager
{
    protected static string $relationship = 'resepProduk';

    public function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('product_id')
                    ->searchable()
                    ->preload()
                    ->required()
                    ->relationship('product', 'nama'),
                Forms\Components\Select::make('bahan_baku_id')
                    ->searchable()
                    ->preload()
                    ->required()
                    ->relationship('bahanBaku', 'nama'),
                Forms\Components\TextInput::make('kuantitas')
                    ->required()
                    ->numeric(0),
            ]);
    }

    public function table(Table $table): Table
    {
        return $table
            ->recordTitleAttribute('nama')
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('NO')
                    ->rowIndex()
                    ->searchable(),
                Tables\Columns\TextColumn::make('product.kode_produk')
                    ->label('Kode Produk'),
                Tables\Columns\TextColumn::make('product.nama')
                    ->label('Produk'),
                Tables\Columns\TextColumn::make('bahanBaku.nama'),
                Tables\Columns\TextColumn::make('kuantitas'),
            ])
            ->filters([
                //
            ])
            ->headerActions([
                Tables\Actions\CreateAction::make(),
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }
}
