<?php

namespace App\Filament\Resources\ProduksiResource\Pages;

use Filament\Actions;
use App\Models\Produksi;
use Filament\Resources\Pages\CreateRecord;
use App\Filament\Resources\ProduksiResource;

class CreateProduksi extends CreateRecord
{
    protected static string $resource = ProduksiResource::class;
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function mutateFormDataBeforeCreate(array $data): array
    {
        // Hitung HPP pakai model
        $produksi = new Produksi($data);
        $data['hpp_per_item'] = $produksi->hitungHPP();

        // Update juga ke kolom HPP produk (optional)
        $produksi->product?->update([
            'hpp' => $data['hpp_per_item'],
        ]);

        return $data;
    }
}
