<?php

namespace App\Filament\Resources\ProduksiResource\Pages;

use Filament\Actions;
use App\Models\Produksi;
use Filament\Resources\Pages\EditRecord;
use App\Filament\Resources\ProduksiResource;

class EditProduksi extends EditRecord
{
    protected static string $resource = ProduksiResource::class;
    protected function getRedirectUrl(): string
    {
        return $this->getResource()::getUrl('index');
    }

    protected function getHeaderActions(): array
    {
        return [
            Actions\DeleteAction::make(),
        ];
    }
    protected function mutateFormDataBeforeSave(array $data): array
    {
        $produksi = new Produksi($data);
        $data['hpp_per_item'] = $produksi->hitungHPP();

        $produksi->product?->update([
            'hpp' => $data['hpp_per_item'],
        ]);

        return $data;
    }
}
