<?php

namespace App\Filament\Resources;

use App\Filament\Resources\ResepProdukResource\Pages;
use App\Filament\Resources\ResepProdukResource\RelationManagers;
use App\Models\ResepProduk;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class ResepProdukResource extends Resource
{
    protected static ?string $model = ResepProduk::class;

    protected static ?string $navigationIcon = 'heroicon-o-circle-stack';
    protected static ?string $navigationGroup = 'Produk & Bahan Baku';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('product_id')
                    ->searchable()
                    ->preload()
                    ->required()
                    ->relationship('product', 'nama'),
                Forms\Components\Select::make('bahan_baku_id')
                    ->searchable()
                    ->preload()
                    ->required()
                    ->relationship('bahanBaku', 'nama'),
                Forms\Components\TextInput::make('kuantitas')
                    ->required()
                    ->numeric(0),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(function () {
                return ResepProduk::orderBy('id', 'DESC');
            })
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('NO')
                    ->rowIndex()
                    ->searchable(),
                Tables\Columns\TextColumn::make('product.kode_produk')
                    ->numeric()
                    ->searchable(),
                Tables\Columns\TextColumn::make('product.nama')
                    ->numeric()
                    ->searchable(),
                Tables\Columns\TextColumn::make('bahanBaku.nama')
                    ->numeric()
                    ->searchable(),
                Tables\Columns\TextColumn::make('kuantitas')
                    ->numeric()
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->searchable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                // Tables\Actions\EditAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListResepProduks::route('/'),
            // 'create' => Pages\CreateResepProduk::route('/create'),
            // 'edit' => Pages\EditResepProduk::route('/{record}/edit'),
        ];
    }
}
