<?php

namespace App\Filament\Resources;

use App\Filament\Resources\StokMasukResource\Pages;
use App\Filament\Resources\StokMasukResource\RelationManagers;
use App\Models\StokMasuk;
use Filament\Forms;
use Filament\Forms\Form;
use Filament\Resources\Resource;
use Filament\Tables;
use Filament\Tables\Table;
use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\SoftDeletingScope;

class StokMasukResource extends Resource
{
    protected static ?string $model = StokMasuk::class;

    protected static ?string $navigationIcon = 'heroicon-o-square-3-stack-3d';
    protected static ?string $navigationGroup = 'Stok';

    public static function form(Form $form): Form
    {
        return $form
            ->schema([
                Forms\Components\Select::make('product_id')
                    ->label('Kode Produk - Nama - Stock')
                    ->relationship('product', 'nama')
                    ->getOptionLabelFromRecordUsing(function ($record) {
                        return "{$record->kode_produk} - {$record->nama} - Stock {$record->stok}";
                    })
                    ->preload()
                    ->searchable()
                    ->required()
                    ->reactive()
                    ->afterStateUpdated(function ($state, callable $set) {
                        // Ambil harga_jual dari product dan set ke harga_satuan
                        $product = \App\Models\Product::find($state);
                        if ($product) {
                            $set('harga_satuan', $product->harga_jual);
                            $set('subtotal', $product->harga_jual); // default kuantitas = 1
                        } else {
                            $set('harga_satuan', null);
                            $set('subtotal', null);
                        }
                    }),
                Forms\Components\DatePicker::make('tanggal')
                    ->required(),
                Forms\Components\TextInput::make('jumlah')
                    ->required()
                    ->numeric(),
                Forms\Components\TextInput::make('keterangan')
                    ->maxLength(255),
            ]);
    }

    public static function table(Table $table): Table
    {
        return $table
            ->query(function () {
                return StokMasuk::orderBy('id', 'DESC');
            })
            ->columns([
                Tables\Columns\TextColumn::make('id')
                    ->label('NO')
                    ->rowIndex()
                    ->searchable(),
                Tables\Columns\TextColumn::make('product.kode_produk')
                    ->label('Kode Produk')
                    ->searchable(),
                Tables\Columns\TextColumn::make('product.nama')
                    ->searchable(),
                Tables\Columns\TextColumn::make('tanggal')
                    ->date()
                    ->searchable(),
                Tables\Columns\TextColumn::make('jumlah')
                    ->numeric()
                    ->searchable(),
                Tables\Columns\TextColumn::make('keterangan')
                    ->searchable(),
                Tables\Columns\TextColumn::make('created_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
                Tables\Columns\TextColumn::make('updated_at')
                    ->dateTime()
                    ->sortable()
                    ->toggleable(isToggledHiddenByDefault: true),
            ])
            ->filters([
                //
            ])
            ->actions([
                Tables\Actions\EditAction::make(),
                Tables\Actions\DeleteAction::make(),
            ])
            ->bulkActions([
                Tables\Actions\BulkActionGroup::make([
                    Tables\Actions\DeleteBulkAction::make(),
                ]),
            ]);
    }

    public static function getRelations(): array
    {
        return [
            //
        ];
    }

    public static function getPages(): array
    {
        return [
            'index' => Pages\ListStokMasuks::route('/'),
            // 'create' => Pages\CreateStokMasuk::route('/create'),
            // 'edit' => Pages\EditStokMasuk::route('/{record}/edit'),
        ];
    }
}
