<?php

namespace App\Filament\Widgets;

use App\Models\InvoiceItem;
use Filament\Widgets\ChartWidget;

class TerlarisChart extends ChartWidget
{
    protected static ?string $heading = 'Produk Terlaris Bulan Ini';

    protected static ?int $sort = 2;

    protected function getData(): array
    {
        // Ambil data invoice item untuk bulan ini
        $items = InvoiceItem::with('product')
            ->whereMonth('created_at', now()->month)
            ->whereYear('created_at', now()->year)
            ->get();

        // Group by product_id dan jumlahkan kuantitas
        $produk = $items->groupBy('product_id')->map(function ($group) {
            return [
                'nama' => $group->first()->product->nama ?? 'Produk tidak ditemukan',
                'jumlah' => $group->sum('kuantitas'),
            ];
        })->sortByDesc('jumlah')->take(10); // Ambil 10 teratas

        // Siapkan data untuk chart
        return [
            'labels' => $produk->pluck('nama')->toArray(),
            'datasets' => [
                [
                    'label' => 'Jumlah Terjual',
                    'data' => $produk->pluck('jumlah')->toArray(),
                    'backgroundColor' => '#f97316',
                    'borderRadius' => 5,
                ],
            ],
        ];
    }

    protected function getType(): string
    {
        return 'bar';
    }
}
