<?php

namespace App\Http\Controllers;

use App\Models\Bank;
use App\Models\Invoice;
use App\Models\ProfileApp;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;

class InvoicePrintController extends Controller
{
    //
    public function cetak(Invoice $invoice)
    {
        $profileApp = ProfileApp::first();
        $bank = Bank::all();
        $pdf = Pdf::loadView('pdf.invoice', [
            'invoice' => $invoice->load(['pelanggan', 'items.product']),
            'profileApp' => $profileApp,
            'bank' => $bank,
        ]);

        return $pdf->stream('Invoice-' . $invoice->kode_invoice . '.pdf');
        // return $pdf->download('Invoice-'.$invoice->kode_invoice.'.pdf'); // kalau mau langsung download
    }
}
