<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Invoice extends Model
{
    //
    use HasFactory;
    protected $guarded = ['id'];

    public function items()
    {
        return $this->hasMany(InvoiceItem::class);
    }
    public function pelanggan()
    {
        return $this->belongsTo(Pelanggan::class);
    }
    public function invoiceItem()
    {
        return $this->hasOne(InvoiceItem::class, 'invoice_id');
    }
    public function updateTotal(): void
    {
        $this->total = $this->items()->sum('subtotal');
        $this->save();
    }
}
