<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class InvoiceItem extends Model
{
    //
    use HasFactory;
    protected $guarded = ['id'];

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }


    protected static function booted()
    {
        // laba_rugi
        static::saving(function ($item) {
            $hpp = $item->product?->hpp ?? 0;

            $item->subtotal = $item->kuantitas * $item->harga_satuan;
            $item->laba_rugi = $item->subtotal - ($item->kuantitas * $hpp);
        });

        static::created(function ($item) {
            // 1️⃣ Kurangi stok produk
            $item->product?->decrement('stok', $item->kuantitas);

            // 2️⃣ Update total invoice
            $item->invoice?->updateTotal();

            // ✅ Tambahkan catatan StokKeluar
            StokKeluar::create([
                'product_id'  => $item->product_id,
                'jumlah'      => $item->kuantitas,
                'tanggal'     => now(),
                'keterangan'  => 'Transaksi Penjualan',
                'invoice_item_id' => $item->id,
            ]);
        });

        static::updated(function ($item) {
            // 1️⃣ Hitung selisih kuantitas
            $originalQty = $item->getOriginal('kuantitas');
            $selisih = $item->kuantitas - $originalQty;

            // 2️⃣ Update stok produk
            $item->product?->decrement('stok', $selisih);

            // 3️⃣ Update total invoice
            $item->invoice?->updateTotal();

            // ✅ Update catatan stok keluar
            $item->stokKeluar?->update([
                'jumlah' => $item->kuantitas,
                'tanggal' => now(),
            ]);
        });

        static::deleted(function ($item) {
            // 1️⃣ Tambahkan kembali stok produk
            $item->product?->increment('stok', $item->kuantitas);

            // 2️⃣ Update total invoice
            $item->invoice?->updateTotal();

            // ✅ Hapus catatan stok keluar
            $item->stokKeluar?->delete();
        });
    }
    public function stokKeluar()
    {
        return $this->hasOne(StokKeluar::class);
    }
}
