<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Produksi extends Model
{
    //
    use HasFactory;
    protected $guarded = ['id'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function hitungHPP(): float
    {
        $resep = ResepProduk::with('bahanBaku')
            ->where('product_id', $this->product_id)
            ->get();

        $total_bahan = 0;

        foreach ($resep as $item) {
            if (!$item->bahanBaku) continue;

            $total_bahan += $item->kuantitas * $item->bahanBaku->harga_per_satuan;
        }

        $total = $total_bahan + $this->biaya_bubut + $this->biaya_finish;

        return $this->jumlah_dibuat > 0 ? round($total / $this->jumlah_dibuat, 2) : 0;
    }
}
