<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StokKeluar extends Model
{
    //
    use HasFactory;
    protected $guarded = ['id'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    public function invoiceItem()
    {
        return $this->belongsTo(InvoiceItem::class);
    }

    public function updateStokKeluar(): void
    {
        $this->keterangan = 'Transaksi Penjualan';
        $this->tanggal = $this->items()->sum('created_at');
        $this->product_id = $this->items()->sum('product_id');
        $this->jumlah = $this->items()->sum('kuantitas');
        $this->save();
    }
}
