<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class StokMasuk extends Model
{
    //
    use HasFactory;
    protected $guarded = ['id'];

    public function product()
    {
        return $this->belongsTo(Product::class);
    }
    protected static function booted()
    {
        // Saat data baru dimasukkan
        static::created(function ($masuk) {
            $masuk->product?->increment('stok', $masuk->jumlah);
        });

        // Saat data diubah
        static::updated(function ($masuk) {
            $originalQty = $masuk->getOriginal('jumlah');
            $selisih = $masuk->jumlah - $originalQty;

            $masuk->product?->increment('stok', $selisih);
        });

        // Saat data dihapus
        static::deleted(function ($masuk) {
            $currentStok = $masuk->product->stok ?? 0;
            $jumlah = min($masuk->jumlah, $currentStok); // biar tidak minus

            $masuk->product?->decrement('stok', $jumlah);
        });
    }
}
