<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('produksis', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->decimal('berat_total', 12, 2);
            $table->decimal('biaya_bubut', 12, 2)->default(0);
            $table->decimal('biaya_finish', 12, 2)->default(0);
            $table->decimal('hpp_per_item', 12, 2)->nullable();
            $table->integer('jumlah_dibuat');
            $table->date('tanggal');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('produksis');
    }
};
