<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('stok_keluars', function (Blueprint $table) {
            //
            $table->foreignId('invoice_item_id')
                ->nullable()
                ->after('product_id')
                ->constrained()
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('stok_keluars', function (Blueprint $table) {
            //
            $table->dropForeign(['invoice_item_id']);
            $table->dropColumn('invoice_item_id');
        });
    }
};
