<!DOCTYPE html>
<html>

<head>
    <meta charset="UTF-8">
    <title>Laporan Laba Rugi</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            margin: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }

        th,
        td {
            padding: 8px;
            border: 1px solid #ccc;
            text-align: left;
        }

        th {
            background-color: #f97316;
            color: white;
        }

        .right {
            text-align: right;
        }

        .center {
            text-align: center;
        }

        .watermark {
            position: fixed;
            top: 45%;
            left: 35%;
            opacity: 0.05;
            z-index: -1;
            width: 300px;
        }
    </style>
</head>

<body>
    <img src="{{ public_path('logo.png') }}" class="watermark" alt="Watermark">

    <h2>Laporan Laba/Rugi</h2>
    <p>Periode: {{ $judulPeriode }}</p>

    <table>
        <thead>
            <tr>
                <th>#</th>
                <th>Kode Invoice</th>
                <th>Tanggal</th>
                <th>Pelanggan</th>
                <th>Produk</th>
                <th>Kuantitas</th>
                <th>Harga Jual</th>
                <th>HPP</th>
                <th>Subtotal</th>
                <th>Laba / Rugi</th>
            </tr>
        </thead>
        <tbody>
            @php
                $no = 1;
                $grandLaba = 0;
            @endphp
            @foreach ($data as $invoice)
                @foreach ($invoice['items'] as $item)
                    <tr>
                        <td class="center">{{ $no++ }}</td>
                        <td>{{ $invoice['kode_invoice'] }}</td>
                        <td>{{ \Carbon\Carbon::parse($invoice['tanggal'])->format('d/m/Y') }}</td>
                        <td>{{ $invoice['pelanggan']['nama'] ?? '-' }}</td>
                        <td>{{ $item['product']['nama'] ?? '-' }}</td>
                        <td class="center">{{ $item['kuantitas'] }}</td>
                        <td class="right">Rp {{ number_format($item['harga_satuan'], 0, ',', '.') }}</td>
                        <td class="right">Rp {{ number_format($item['product']['hpp'] ?? 0, 0, ',', '.') }}</td>
                        <td class="right">Rp {{ number_format($item['subtotal'], 0, ',', '.') }}</td>
                        <td class="right">Rp {{ number_format($item['laba_rugi'], 0, ',', '.') }}</td>
                    </tr>
                    @php $grandLaba += $item['laba_rugi']; @endphp
                @endforeach
            @endforeach
        </tbody>
    </table>

    <h3 style="text-align: right; margin-top: 20px;">Total Laba/Rugi: Rp {{ number_format($grandLaba, 0, ',', '.') }}
    </h3>
</body>

</html>
