<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Laporan Produk Terlaris - {{ $judulPeriode }}</title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 30px;
            position: relative;
        }

        .watermark {
            position: fixed;
            top: 35%;
            left: 25%;
            width: 400px;
            opacity: 0.06;
            z-index: -1;
        }

        h2 {
            text-align: center;
            margin-bottom: 5px;
        }

        .periode {
            text-align: center;
            font-size: 14px;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
        }

        th {
            background-color: #eee;
            font-weight: bold;
            text-align: center;
        }

        td.right {
            text-align: right;
        }

        td.center {
            text-align: center;
        }

        .total-row {
            font-weight: bold;
            background-color: #f3f3f3;
        }
    </style>
</head>

<body>
    {{-- Watermark --}}
    <img src="{{ public_path('logo.png') }}" class="watermark" alt="Watermark">

    <h2>Laporan Produk Terlaris</h2>
    <div class="periode">Periode: {{ $judulPeriode }}</div>

    @php
        $produkTerlaris = collect();

        foreach ($data as $invoice) {
            foreach ($invoice['items'] as $item) {
                $id = $item['product']['id'] ?? null;
                if (!$id) {
                    continue;
                }

                $nama = $item['product']['nama'] ?? '-';
                $kuantitas = $item['kuantitas'] ?? 0;
                $subtotal = $item['subtotal'] ?? 0;

                if ($produkTerlaris->has($id)) {
                    $produkTerlaris[$id]['kuantitas'] += $kuantitas;
                    $produkTerlaris[$id]['subtotal'] += $subtotal;
                } else {
                    $produkTerlaris[$id] = [
                        'nama' => $nama,
                        'kuantitas' => $kuantitas,
                        'subtotal' => $subtotal,
                    ];
                }
            }
        }

        $produkTerlaris = $produkTerlaris->sortByDesc('kuantitas');
    @endphp

    <table>
        <thead>
            <tr>
                <th>Peringkat</th>
                <th>Nama Produk</th>
                <th>Total Kuantitas Terjual</th>
                <th>Total Penjualan</th>
            </tr>
        </thead>
        <tbody>
            @php
                $no = 1;
                $grandTotal = 0;
            @endphp
            @foreach ($produkTerlaris as $produk)
                <tr>
                    <td class="center">{{ $no++ }}</td>
                    <td>{{ $produk['nama'] }}</td>
                    <td class="center">{{ $produk['kuantitas'] }}</td>
                    <td class="right">Rp {{ number_format($produk['subtotal'], 0, ',', '.') }}</td>
                </tr>
                @php $grandTotal += $produk['subtotal']; @endphp
            @endforeach
            <tr class="total-row">
                <td colspan="3" class="right">Total Penjualan Seluruh Produk</td>
                <td class="right">Rp {{ number_format($grandTotal, 0, ',', '.') }}</td>
            </tr>
        </tbody>
    </table>
</body>

</html>
