<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>Invoice #83</title>
    <style>
        body {
            font-family: Georgia, serif;
            margin: 40px auto;
            max-width: 900px;
            color: #2c2c2c;
            background-color: #fff;
        }

        .invoice-header {
            display: flex;
            justify-content: space-between;
            align-items: flex-start;
            margin-bottom: 2rem;
        }

        .invoice-header img {
            max-height: 50px;
            display: block;
        }

        .invoice-id {
            font-style: italic;
            color: #b35f0c;
            font-weight: bold;
            font-size: 1.3rem;
            margin-top: 10px;
        }

        .invoice-info {
            font-style: italic;
            font-weight: 700;
            font-size: 1rem;
            margin-bottom: 0.5rem;
        }

        .invoice-info span {
            font-weight: 700;
        }

        .invoice-info .customer {
            font-style: normal;
            font-weight: 700;
            margin-bottom: 0.2rem;
        }

        .invoice-info .customer-address {
            font-style: italic;
            font-weight: normal;
            margin-top: 0;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 1rem;
            margin-bottom: 2.5rem;
        }

        thead tr {
            background: #f79444;
            color: white;
        }

        thead th {
            padding: 0.7rem;
            text-align: center;
            font-weight: 700;
            font-size: 0.85rem;
            /* border: 1px solid #e2871f; */
            vertical-align: middle;
            line-height: 1.2;
        }

        tbody td {
            /* border: 1px solid #d9d4d0; */
            padding: 0.6rem 1rem;
            vertical-align: top;
            font-size: 0.9rem;
        }

        tbody td.name-col {
            text-align: left;
            line-height: 1.3;
        }

        tbody td.center-num {
            text-align: center;
        }

        tbody td.right-num {
            text-align: right;
        }

        .summary {
            max-width: 360px;
            margin-left: auto;
            font-size: 0.95rem;
        }

        .summary p {
            margin-bottom: 0.3rem;
            font-style: italic;
        }

        .summary p.total strong {
            font-weight: 700;
        }

        .footer-info {
            display: flex;
            justify-content: space-between;
            font-size: 0.9rem;
            border-top: 1px solid #6ea0cc;
        }

        .footer-info div {
            margin-top: 0.7rem;
            max-width: 45%;
        }

        .footer-info div strong {
            font-weight: 700;
            display: block;
            margin-bottom: 0.3rem;
        }

        .footer-info div span,
        .footer-info div i {
            font-style: italic;
        }

        .watermark {
            position: fixed;
            top: 30%;
            left: 25%;
            width: 400px;
            opacity: 0.1;
            z-index: -1;
        }
    </style>
</head>

<body>
    <img src="{{ public_path('storage/' . $profileApp->logo ?? '-') }}" class="watermark" alt="Watermark">

    <div class="invoice-header">
        <table style="width: 100%">
            <tr>
                <td style="width: 50%"><img src="{{ public_path('storage/' . $profileApp->logo ?? '-') }}"
                        alt="Bakulpulley.com Logo" />
                </td>
                <td>
                    <div class="invoice-id">Invoice # {{ $invoice->kode_invoice }}</div>
                </td>
            </tr>
        </table>
    </div>
    <div style="display:flex; justify-content:space-between; margin-bottom:1rem; font-style: italic; font-weight: 600;">
        <table style="width: 100%">
            <tr>
                <td style="width: 50%"><span>Tanggal:</span> {{ date('d F Y', strtotime($invoice->tanggal)) }} </td>
                <td>
                    <b>PELANGGAN:</b> <br>
                    {{ $invoice->pelanggan->nama ?? '-' }} <br>
                    {{ $invoice->pelanggan->no_hp ?? '-' }} <br>
                </td>
            </tr>
        </table>
    </div>
    <table border="1">
        <thead>
            <tr>
                <th>Produk</th>
                <th>Kuantitas</th>
                <th>Harga Satuan</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            @foreach ($invoice->items as $item)
                <tr>
                    <td class="name-col">{{ $item->product->nama ?? '-' }}</td>
                    <td class="center-num">{{ $item->kuantitas }}</td>
                    <td class="right-num">Rp {{ number_format($item->harga_satuan, 0, ',', '.') }}</td>
                    <td class="right-num">Rp {{ number_format($item->subtotal, 0, ',', '.') }}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
    <div class="summary">
        <p class="total"><strong>Total</strong> <strong style="float:right;">Rp
                {{ number_format($invoice->total, 0, ',', '.') }}</strong></p>
    </div>
    <div class="footer-info">
        <table style="width: 100%">
            <tr>
                <td style="width: 65%">
                    <strong>{{ $profileApp->nama ?? '-' }}</strong><br>
                    [{{ $profileApp->alamat ?? '-' }}] <br>
                    Telepon: [{{ $profileApp->telp ?? '-' }}]
                </td>
                <td>
                    @foreach ($bank as $item)
                        <strong>{{ $item->nama_bank ?? '-' }}</strong><br>
                        <i>Nomor rekening bank:</i> [{{ $item->norek ?? '-' }}]<br>
                        <br>
                    @endforeach
                </td>
            </tr>
        </table>
    </div>
</body>

</html>
