<!DOCTYPE html>
<html lang="id">

<head>
    <meta charset="UTF-8">
    <title>Laporan Penjualan - <?php echo e($judulPeriode); ?></title>
    <style>
        body {
            font-family: DejaVu Sans, sans-serif;
            font-size: 12px;
            color: #333;
            margin: 30px;
            position: relative;
        }

        .watermark {
            position: fixed;
            top: 35%;
            left: 25%;
            width: 400px;
            opacity: 0.06;
            z-index: -1;
        }

        h2 {
            text-align: center;
            margin-bottom: 5px;
        }

        .periode {
            text-align: center;
            font-size: 14px;
            margin-bottom: 20px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }

        th,
        td {
            border: 1px solid #ccc;
            padding: 6px 8px;
            text-align: left;
        }

        th {
            background-color: #eee;
            font-weight: bold;
            text-align: center;
        }

        td.right {
            text-align: right;
        }

        td.center {
            text-align: center;
        }

        .total-row {
            font-weight: bold;
            background-color: #f3f3f3;
        }
    </style>
</head>

<body>
    
    <img src="<?php echo e(public_path('logo.png')); ?>" class="watermark" alt="Watermark">

    <h2>Laporan Penjualan</h2>
    <div class="periode">Periode: <?php echo e($judulPeriode); ?></div>

    <table>
        <thead>
            <tr>
                <th>No</th>
                <th>Kode Invoice</th>
                <th>Tanggal</th>
                <th>Pelanggan</th>
                <th>Kode Produk</th>
                <th>Produk</th>
                <th>Kuantitas</th>
                <th>Harga Satuan</th>
                <th>Subtotal</th>
            </tr>
        </thead>
        <tbody>
            <?php
                $no = 1;
                $grandTotal = 0;
            ?>
            <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $invoice): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php $__currentLoopData = $invoice['items']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="center"><?php echo e($no++); ?></td>
                        <td><?php echo e($invoice['kode_invoice']); ?></td>
                        <td><?php echo e(\Carbon\Carbon::parse($invoice['tanggal'])->format('d/m/Y')); ?></td>
                        <td><?php echo e($invoice['pelanggan']['nama'] ?? '-'); ?></td>
                        <td><?php echo e($item['product']['kode_produk'] ?? '-'); ?></td>
                        <td><?php echo e($item['product']['nama'] ?? '-'); ?></td>
                        <td class="center"><?php echo e($item['kuantitas']); ?></td>
                        <td class="right">Rp <?php echo e(number_format($item['harga_satuan'], 0, ',', '.')); ?></td>
                        <td class="right">Rp <?php echo e(number_format($item['subtotal'], 0, ',', '.')); ?></td>
                    </tr>
                    <?php
                        $grandTotal += $item['subtotal'];
                    ?>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <tr class="total-row">
                <td colspan="8" class="right">Total Penjualan</td>
                <td class="right">Rp <?php echo e(number_format($grandTotal, 0, ',', '.')); ?></td>
            </tr>
        </tbody>
    </table>
</body>

</html>
<?php /**PATH C:\laragon\www\hpp-penjualan-laravel\resources\views/exports/LaporanPenjualan.blade.php ENDPATH**/ ?>